/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.sgui.api.elements;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.mixin.StaticAccessor;
import it.unimi.dsi.fastutil.objects.ReferenceSortedSets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.UUID;
import net.minecraft.class_10712;
import net.minecraft.class_12079;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8685;
import net.minecraft.class_9280;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9336;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GuiElementBuilder
implements GuiElementBuilderInterface<GuiElementBuilder> {
    protected class_1799 itemStack = new class_1799((class_1935)class_1802.field_8446);
    protected GuiElementInterface.ClickCallback callback = GuiElementInterface.EMPTY_CALLBACK;
    private boolean hideComponentTooltips;
    private boolean noTooltips;

    public GuiElementBuilder() {
    }

    public GuiElementBuilder(class_1792 item) {
        this.itemStack = new class_1799((class_1935)item);
    }

    public GuiElementBuilder(class_2960 model) {
        this.model(model);
    }

    public GuiElementBuilder(class_1792 item, int count) {
        this.itemStack = new class_1799((class_1935)item, count);
    }

    public GuiElementBuilder(class_1799 stack) {
        this.itemStack = stack.method_7972();
    }

    public static GuiElementBuilder from(class_1799 stack) {
        return new GuiElementBuilder(stack);
    }

    @Deprecated
    public static List<class_2561> getLore(class_1799 stack) {
        return ((class_9290)stack.method_58695(class_9334.field_49632, (Object)class_9290.field_49340)).comp_2400();
    }

    public GuiElementBuilder setItem(class_1792 item) {
        this.itemStack = new class_1799((class_6880)item.method_40131(), this.itemStack.method_7947(), this.itemStack.method_57380());
        return this;
    }

    public GuiElementBuilder setName(class_2561 name) {
        this.itemStack.method_57379(class_9334.field_49631, (Object)name.method_27661().method_27694(GuiHelpers.STYLE_CLEARER));
        return this;
    }

    public GuiElementBuilder setItemName(class_2561 name) {
        this.itemStack.method_57379(class_9334.field_50239, (Object)name.method_27661());
        return this;
    }

    public GuiElementBuilder setRarity(class_1814 rarity) {
        this.itemStack.method_57379(class_9334.field_50073, (Object)rarity);
        return this;
    }

    public GuiElementBuilder setCount(int count) {
        this.itemStack.method_7939(count);
        return this;
    }

    public GuiElementBuilder setMaxCount(int count) {
        this.itemStack.method_57379(class_9334.field_50071, (Object)count);
        return this;
    }

    public GuiElementBuilder setLore(List<class_2561> lore) {
        ArrayList<class_5250> l = new ArrayList<class_5250>(lore.size());
        for (class_2561 t : lore) {
            l.add(t.method_27661().method_27694(GuiHelpers.STYLE_CLEARER));
        }
        this.itemStack.method_57379(class_9334.field_49632, (Object)new class_9290(l));
        return this;
    }

    public GuiElementBuilder setLoreRaw(List<class_2561> lore) {
        this.itemStack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
        return this;
    }

    public GuiElementBuilder addLoreLine(class_2561 lore) {
        this.itemStack.method_57367(class_9334.field_49632, (Object)class_9290.field_49340, (Object)lore.method_27661().method_27694(GuiHelpers.STYLE_CLEARER), class_9290::method_57499);
        return this;
    }

    public GuiElementBuilder addLoreLineRaw(class_2561 lore) {
        this.itemStack.method_57367(class_9334.field_49632, (Object)class_9290.field_49340, (Object)lore, class_9290::method_57499);
        return this;
    }

    public GuiElementBuilder setDamage(int damage) {
        this.itemStack.method_57379(class_9334.field_49629, (Object)damage);
        return this;
    }

    public GuiElementBuilder setMaxDamage(int damage) {
        this.itemStack.method_57379(class_9334.field_50072, (Object)damage);
        return this;
    }

    public GuiElementBuilder noDefaults() {
        for (class_9336 x : this.itemStack.method_7909().method_57347()) {
            if (x.comp_2443() == class_9334.field_54199 || this.itemStack.method_58694(x.comp_2443()) != x.comp_2444()) continue;
            this.itemStack.method_57379(x.comp_2443(), null);
        }
        return this;
    }

    @Nullable
    public <T> T getComponent(class_9331<T> type) {
        return (T)this.itemStack.method_58694(type);
    }

    public <T> GuiElementBuilder setComponent(class_9331<T> type, @Nullable T value) {
        this.itemStack.method_57379(type, value);
        return this;
    }

    public GuiElementBuilder hideDefaultTooltip() {
        this.hideComponentTooltips = true;
        return this;
    }

    public GuiElementBuilder hideTooltip() {
        this.noTooltips = true;
        return this;
    }

    public GuiElementBuilder enchant(class_6880<class_1887> enchantment, int level) {
        this.itemStack.method_7978(enchantment, level);
        return this;
    }

    public GuiElementBuilder enchant(MinecraftServer server, class_5321<class_1887> enchantment, int level) {
        return this.enchant((class_7225.class_7874)server.method_30611(), enchantment, level);
    }

    public GuiElementBuilder enchant(class_7225.class_7874 lookup, class_5321<class_1887> enchantment, int level) {
        return this.enchant((class_6880<class_1887>)lookup.method_46762(class_7924.field_41265).method_46747(enchantment), level);
    }

    public GuiElementBuilder glow() {
        this.itemStack.method_57379(class_9334.field_49641, (Object)true);
        return this;
    }

    public GuiElementBuilder glow(boolean value) {
        this.itemStack.method_57379(class_9334.field_49641, (Object)value);
        return this;
    }

    public GuiElementBuilder setCustomModelData(List<Float> floats, List<Boolean> flags, List<String> strings, List<Integer> colors) {
        this.itemStack.method_57379(class_9334.field_49637, (Object)new class_9280(floats, flags, strings, colors));
        return this;
    }

    public GuiElementBuilder model(class_2960 model) {
        this.itemStack.method_57379(class_9334.field_54199, (Object)model);
        return this;
    }

    public GuiElementBuilder model(class_1792 model) {
        this.itemStack.method_57379(class_9334.field_54199, (Object)((class_2960)model.method_57347().method_58694(class_9334.field_54199)));
        return this;
    }

    public GuiElementBuilder unbreakable() {
        this.itemStack.method_57379(class_9334.field_49630, (Object)class_3902.field_17274);
        return this;
    }

    public GuiElementBuilder setProfile(GameProfile profile) {
        if (!profile.properties().isEmpty()) {
            return this.setProfile(class_9296.method_73307((GameProfile)profile));
        }
        if (profile.name().isEmpty()) {
            return this.setProfile(class_9296.method_73312((UUID)profile.id()));
        }
        if (profile.id().equals(class_156.field_25140)) {
            return this.setProfile(class_9296.method_74889((String)profile.name()));
        }
        return this;
    }

    public GuiElementBuilder setProfile(String name) {
        return this.setProfile(class_9296.method_74889((String)name));
    }

    public GuiElementBuilder setProfile(UUID uuid) {
        return this.setProfile(class_9296.method_73312((UUID)uuid));
    }

    public GuiElementBuilder setProfile(class_2960 textureId) {
        return this.setProfile((class_9296)StaticAccessor.createStatic((Either<GameProfile, class_9296.class_11757>)Either.right((Object)class_9296.class_11757.field_63032), new class_8685.class_11892(Optional.of(new class_12079.class_10726(textureId)), Optional.empty(), Optional.empty(), Optional.empty())));
    }

    public GuiElementBuilder setProfile(class_8685.class_11892 info) {
        return this.setProfile((class_9296)StaticAccessor.createStatic((Either<GameProfile, class_9296.class_11757>)Either.right((Object)class_9296.class_11757.field_63032), info));
    }

    public GuiElementBuilder setProfile(class_9296 component) {
        this.itemStack.method_57379(class_9334.field_49617, (Object)component);
        return this;
    }

    public GuiElementBuilder setProfileSkinTexture(String value) {
        return this.setProfileSkinTexture(value, null, null);
    }

    public GuiElementBuilder setProfileSkinTexture(String value, @Nullable String signature, @Nullable UUID uuid) {
        PropertyMap map = new PropertyMap((Multimap)ImmutableMultimap.of((Object)"textures", (Object)new Property("textures", value, signature)));
        return this.setProfile(new GameProfile(uuid != null ? uuid : class_156.field_25140, "", map));
    }

    @Deprecated
    public GuiElementBuilder setSkullOwner(GameProfile profile, @Nullable MinecraftServer server) {
        return this.setProfile(profile);
    }

    @Deprecated
    public GuiElementBuilder setSkullOwner(String value) {
        return this.setSkullOwner(value, null, null);
    }

    @Deprecated
    public GuiElementBuilder setSkullOwner(String value, @Nullable String signature, @Nullable UUID uuid) {
        return this.setProfileSkinTexture(value, signature, uuid);
    }

    @Override
    public GuiElementBuilder setCallback(GuiElementInterface.ClickCallback callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public GuiElementBuilder setCallback(GuiElementInterface.ItemClickCallback callback) {
        this.callback = callback;
        return this;
    }

    public class_1799 asStack() {
        class_1799 copy = this.itemStack.method_7972();
        if (this.noTooltips) {
            copy.method_57379(class_9334.field_56400, (Object)new class_10712(true, (SequencedSet)ReferenceSortedSets.emptySet()));
        } else if (this.hideComponentTooltips) {
            class_10712 comp = class_10712.field_56318;
            for (class_9336 entry : this.itemStack.method_57353()) {
                if (entry.comp_2443() == class_9334.field_50239 || entry.comp_2443() == class_9334.field_49631 || entry.comp_2443() == class_9334.field_49632) continue;
                comp = comp.method_67215(entry.comp_2443(), true);
            }
            copy.method_57379(class_9334.field_56400, (Object)comp);
        }
        return copy;
    }

    @Override
    public GuiElement build() {
        return new GuiElement(this.asStack(), this.callback);
    }

    @Deprecated(forRemoval=true)
    public GuiElementBuilder hideFlags() {
        return this.hideDefaultTooltip();
    }
}

